// This is the script that gives the player command of the squad.
// Step 1:  Record the actionID we used to call this script.
// Step 2:  Some dialog from the officer thanking the player.
// Step 3:  Join the player to the group.
// Step 4:  Make the player leader of the group.
// Step 5:  Have the old leader leave the group and keep himself busy.
// Step 6:  Remove the action from the old leader, so we can only do this once.
// Step 7:  Record a variable that says we've completed this task.  We'll use this for waypoint control.

// This line just records which 'action' we used to take over for the old SL so we can delete it later.
_bossaction = _this select 0; 

// Have the boss thank you for taking over
titletext ["Thanks for taking over, I needed a break!", "PLAIN"];

// Join the player to the current group.  Note that player in this case is an Array.
[player] join group boss;

//  Make the player the leader of the group.
group player selectLeader player;

//  Have the old leader leave the group and do some exercise. :)
[boss] join group objNull;
boss playMove "AmovPercMstpSnonWnonDnon_exercisePushup";

// remove the action once it is activated 
_bossaction removeAction _id;

//  Mark that our player is leader so the rest of the waypoints show up for them.
myPlayerIsLeader = 1;

// Get the rest of the group to follow the player instead of being dismissed.
{_x doFollow player} forEach units group player;


