/*
  *	Mikey's Briefing Template v0.03
  *
  *
  *	Notes: 
  *		- Use the tsk prefix for any tasks you add. This way you know what the varname is for by just looking at it, and 
  *			aids you in preventing using duplicate variable names.
  *
  *
  *		Required briefing commands:		
  *		- Create Note:			player createDiaryRecord ["Diary", ["*The Note Title*", "*The Note Message*"]]; 
  *		- Create Task:			tskExample = player createSimpleTask ["*The Task Title*"];
  *		- Set Task Description:	tskExample setSimpleTaskDescription ["*Task Message*", "*Task Title*", "*Task HUD Title*"];
  *
  *		Optional briefing commands:
  * 		- Set Task Destination:	tskExample setSimpleTaskDestination (getMarkerPos "mkrObj1");  // use an existing marker!
  *		- Set the Current Task:	player setCurrentTask tskExample;
  *		
  *		Formatting:
  *		- To add a newline: 		<br/>
  *		- To add a marker link:	<marker name='mkrObj1'>Attack this area!!!</marker>
  *		- To add an image: 		<img image='somePic.jpg'/> 
  *		   - custom width/height:	<img image='somePic.jpg' width='200' height='200'/>
  *		
  *		Commands to use in-game:
  *		- Set Task State:		tskExample setTaskState "SUCCEEDED";   // states: "SUCCEEDED"  "FAILED"  "CANCELED" "CREATED"
  *		- Get Task State:		taskState tskExample;
  *		- Get Task Description:	taskDescription tskExample;   // returns the *task title* as a string
  *		- Show Task Hint:		[tskExample] call mk_fTaskHint;  // make sure tskExample and the mk_fTaskHint function exist
  *							
  *
  *	Authors: Jinef & mikey
  */

// since we're working with the player object here, make sure it exists
waitUntil { !isNull player }; // all hip now ;-)
waitUntil { player == player };



switch (side player) do 
{
	
	case WEST: // BLUFOR briefing goes here
	{
		player createDiaryRecord["Diary", ["Info", "<br/>He's standing in front of you.  Kill him.  It's not hard.<br/>Wait 10 seconds to ""fail"".<br/>"]];

		tskObj1 = player createSimpleTask["Primary: Kill Grigori Ivanov"]; 
		tskObj1 setSimpleTaskDescription["Grigori Ivanov is bad news, kill him.", "Kill Grigori Ivanov", "Grigori Ivanov"];
		player setCurrentTask tskObj1;
	};
	
	
	case EAST: // REDFOR briefing goes here
	{
		
		
	};
	
	
	case RESISTANCE: // RESISTANCE/INDEPENDENT briefing goes here
	{
		
		
	};
	
	
	case CIVILIAN: // CIVILIAN briefing goes here
	{
		
		
	};
};

